<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; use Illuminate\Support\Facades\Auth;
use App\Models\{Voucher,Redemption};
class DashboardController extends Controller {
  public function loginForm(){ return view('auth.login'); }
  public function login(Request $r){ $r->validate(['email'=>'required|email','password'=>'required']); if(Auth::attempt($r->only('email','password'))){ $r->session()->regenerate(); return redirect()->route('dashboard'); } return back()->withErrors(['email'=>'Invalid credentials'])->onlyInput('email'); }
  public function logout(Request $r){ Auth::logout(); $r->session()->invalidate(); $r->session()->regenerateToken(); return redirect()->route('login'); }
  public function index(){ $todaySales=Voucher::whereDate('created_at',now()->toDateString())->sum('amount'); $todayRedemptions=Redemption::whereDate('redeemed_at',now()->toDateString())->count(); return view('dashboard',compact('todaySales','todayRedemptions')); }
}
