<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; use Illuminate\Support\Facades\Hash;
use App\Models\{Merchant,Cashier,User};
class MerchantController extends Controller {
  public function index(){ $merchants=Merchant::with('cashiers')->paginate(20); return view('merchants.index',compact('merchants')); }
  public function store(Request $r){ $d=$r->validate(['name'=>'required','contact_phone'=>'nullable','address'=>'nullable']); Merchant::create($d+['status'=>'active']); return back()->with('ok','Merchant added'); }
  public function storeCashier(Request $r){
    $d=$r->validate(['merchant_id'=>'required|exists:merchants,id','name'=>'required','phone'=>'nullable','email'=>'required|email|unique:users,email','password'=>'required|min:6']);
    $u=User::create(['name'=>$d['name'],'email'=>$d['email'],'password'=>Hash::make($d['password']),'role'=>'cashier','merchant_id'=>$d['merchant_id']]);
    Cashier::create(['merchant_id'=>$d['merchant_id'],'name'=>$d['name'],'phone'=>$d['phone'] ?? null,'user_id'=>$u->id,'status'=>'active']);
    return back()->with('ok','Cashier created');
  }
}
