<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; use Illuminate\Support\Facades\DB;
use App\Models\{Voucher,Redemption};
class RedemptionController extends Controller {
  public function index(){ return view('redeem.index'); }
  public function redeem(Request $r){
    $r->validate(['code'=>'required']); $code=$r->input('code');
    return DB::transaction(function() use($code){
      $v=Voucher::where('code',$code)->lockForUpdate()->first();
      if(!$v) return back()->withErrors(['code'=>'Voucher not found']);
      if($v->status!=='sent') return back()->withErrors(['code'=>'Voucher not valid']);
      if($v->expires_at && $v->expires_at->isPast()) return back()->withErrors(['code'=>'Voucher expired']);
      $v->status='redeemed'; $v->save();
      Redemption::create(['voucher_id'=>$v->id,'merchant_id'=>auth()->user()->merchant_id ?? null,'cashier_id'=>auth()->id(),'redeemed_at'=>now()]);
      return redirect()->route('redeem.index')->with('ok','Redeemed '.$v->amount);
    });
  }
  public function history(){ $list=Redemption::with('voucher')->latest()->paginate(20); return view('redeem.history',compact('list')); }
}
