<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; use Symfony\Component\HttpFoundation\StreamedResponse;
use App\Models\Redemption;
class ReportController extends Controller {
  public function exportSettlementCsv(Request $r): StreamedResponse {
    $fn='settlement_'.now()->format('Ymd_His').'.csv'; $h=['Content-Type'=>'text/csv','Content-Disposition'=>"attachment; filename=$fn"];
    $q=Redemption::with(['voucher','merchant','cashier'])->orderBy('redeemed_at','desc');
    if($r->from) $q->whereDate('redeemed_at','>=',$r->from);
    if($r->to) $q->whereDate('redeemed_at','<=',$r->to);
    $cb=function() use($q){ $o=fopen('php://output','w'); fputcsv($o,['voucher_code','amount','redeemed_at','merchant','cashier','fee','net_settle']); foreach($q->cursor() as $x){ $amt=optional($x->voucher)->amount ?? 0; $fee=round($amt*0.035,2); $net=$amt-$fee; fputcsv($o,[optional($x->voucher)->code,$amt,$x->redeemed_at,optional($x->merchant)->name,optional($x->cashier)->name,$fee,$net]); } fclose($o); }; return response()->stream($cb,200,$h);
  }
}
