<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request; use Symfony\Component\HttpFoundation\StreamedResponse;
use App\Models\{Voucher,VoucherRecipient};
class VoucherController extends Controller {
  public function index(){ $vouchers=Voucher::latest()->paginate(15); return view('vouchers.index',compact('vouchers')); }
  public function create(){ return view('vouchers.create'); }
  public function store(Request $r){
    $d=$r->validate(['amount'=>'required|numeric|min:1','quantity'=>'required|integer|min:1','recipient_phone'=>'nullable|string']);
    for($i=0;$i<$d['quantity'];$i++){ $code=(string) random_int(10**9,10**10-1);
      $v=Voucher::create(['code'=>$code,'amount'=>$d['amount'],'currency'=>'CDF','status'=>'sent','expires_at'=>now()->addDays(90),'sender_user_id'=>auth()->id()]);
      if($i==0 && !empty($d['recipient_phone'])){ VoucherRecipient::create(['voucher_id'=>$v->id,'recipient_phone'=>$d['recipient_phone']]); /* TODO SMS */ }
    } return redirect()->route('vouchers.index')->with('ok','Vouchers created.');
  }
  public function importCsv(Request $r){ return back()->with('ok','CSV import placeholder'); }
  public function exportCsv(): StreamedResponse { $fn='vouchers_'.now()->format('Ymd_His').'.csv'; $h=['Content-Type'=>'text/csv','Content-Disposition'=>"attachment; filename=$fn"]; $cb=function(){ $o=fopen('php://output','w'); fputcsv($o,['code','amount','currency','status','expires_at','created_at']); foreach(\App\Models\Voucher::cursor() as $v){ fputcsv($o,[$v->code,$v->amount,$v->currency,$v->status,$v->expires_at,$v->created_at]); } fclose($o); }; return response()->stream($cb,200,$h); }
}
