@extends('layouts.app')
@section('content')
<h1 class="text-2xl font-bold mb-4">Merchants & Cashiers</h1>
<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
<div class="bg-white p-4 rounded shadow"><h2 class="font-semibold mb-3">Add Merchant</h2>
<form method="POST" action="{{ route('merchants.store') }}">@csrf
<input name="name" class="w-full border rounded p-2 mb-2" placeholder="Name" required>
<input name="contact_phone" class="w-full border rounded p-2 mb-2" placeholder="Phone">
<input name="address" class="w-full border rounded p-2 mb-2" placeholder="Address">
<button class="px-3 py-2 bg-yellow-400 rounded">Save</button></form></div>
<div class="bg-white p-4 rounded shadow"><h2 class="font-semibold mb-3">Add Cashier</h2>
<form method="POST" action="{{ route('cashiers.store') }}">@csrf
<select name="merchant_id" class="w-full border rounded p-2 mb-2">@foreach ($merchants as $m)<option value="{{ $m->id }}">{{ $m->name }}</option>@endforeach</select>
<input name="name" class="w-full border rounded p-2 mb-2" placeholder="Full name" required>
<input name="phone" class="w-full border rounded p-2 mb-2" placeholder="Phone">
<input name="email" class="w-full border rounded p-2 mb-2" placeholder="Email" required>
<input name="password" type="password" class="w-full border rounded p-2 mb-2" placeholder="Password" required>
<button class="px-3 py-2 bg-yellow-400 rounded">Save</button></form></div></div>
<div class="bg-white rounded shadow overflow-x-auto mt-4"><table class="w-full text-sm">
<thead class="bg-gray-50"><tr><th class="text-left p-2">Merchant</th><th class="text-left p-2">Cashiers</th></tr></thead>
<tbody>@foreach ($merchants as $m)<tr class="border-t"><td class="p-2">{{ $m->name }}</td><td class="p-2">@foreach ($m->cashiers as $c)<div>{{ $c->name }} ({{ $c->status }})</div>@endforeach</td></tr>@endforeach</tbody></table></div>
@endsection
