@extends('layouts.app')
@section('content')
<div class="flex items-center justify-between mb-4"><h1 class="text-2xl font-bold">Vouchers</h1><div class="space-x-2"><a href="{{ route('vouchers.create') }}" class="px-3 py-2 rounded bg-yellow-400">Create</a><a href="{{ route('vouchers.export') }}" class="px-3 py-2 rounded bg-gray-200">Export CSV</a></div></div>
<form method="POST" action="{{ route('vouchers.import') }}" class="bg-white p-4 rounded shadow mb-4" enctype="multipart/form-data">@csrf<div class="flex items-center gap-2"><input type="file" name="csv" class="border p-2 rounded"><button class="px-3 py-2 bg-gray-200 rounded">Import CSV</button></div></form>
<div class="bg-white rounded shadow overflow-x-auto"><table class="w-full text-sm"><thead class="bg-gray-50"><tr><th class="text-left p-2">Code</th><th class="text-left p-2">Amount</th><th class="text-left p-2">Currency</th><th class="text-left p-2">Status</th><th class="text-left p-2">Expires</th><th class="text-left p-2">Created</th></tr></thead><tbody>@foreach ($vouchers as $v)<tr class="border-t"><td class="p-2 font-mono">{{ $v->code }}</td><td class="p-2">{{ number_format($v->amount,2) }}</td><td class="p-2">{{ $v->currency }}</td><td class="p-2">{{ $v->status }}</td><td class="p-2">{{ optional($v->expires_at)->format('Y-m-d') }}</td><td class="p-2">{{ $v->created_at->format('Y-m-d H:i') }}</td></tr>@endforeach</tbody></table></div>
<div class="mt-4">{{ $vouchers->links() }}</div>
@endsection
