<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{DashboardController,VoucherController,RedemptionController,MerchantController,ReportController,SettingsController};
Route::get('/', fn()=>redirect()->route('dashboard'));
Route::get('/login', [DashboardController::class, 'loginForm'])->name('login');
Route::post('/login', [DashboardController::class, 'login']);
Route::post('/logout', [DashboardController::class, 'logout'])->name('logout');
Route::middleware('auth')->group(function () {
  Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
  Route::get('/vouchers', [VoucherController::class, 'index'])->name('vouchers.index');
  Route::get('/vouchers/create', [VoucherController::class, 'create'])->name('vouchers.create');
  Route::post('/vouchers', [VoucherController::class, 'store'])->name('vouchers.store');
  Route::post('/vouchers/import', [VoucherController::class, 'importCsv'])->name('vouchers.import');
  Route::get('/vouchers/export', [VoucherController::class, 'exportCsv'])->name('vouchers.export');
  Route::get('/redeem', [RedemptionController::class, 'index'])->name('redeem.index');
  Route::post('/redeem', [RedemptionController::class, 'redeem'])->name('redeem.submit');
  Route::get('/redemptions/history', [RedemptionController::class, 'history'])->name('redeem.history');
  Route::get('/merchants', [MerchantController::class, 'index'])->name('merchants.index');
  Route::post('/merchants', [MerchantController::class, 'store'])->name('merchants.store');
  Route::post('/cashiers', [MerchantController::class, 'storeCashier'])->name('cashiers.store');
  Route::get('/reports/settlement', [ReportController::class, 'exportSettlementCsv'])->name('reports.settlement');
  Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
  Route::post('/settings', [SettingsController::class, 'update'])->name('settings.update');
});
